#region Using declarations
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Gui;
using NinjaTrader.Gui.Chart;
using NinjaTrader.Gui.SuperDom;
using NinjaTrader.Gui.Tools;
using NinjaTrader.Data;
using NinjaTrader.NinjaScript;
using NinjaTrader.Core.FloatingPoint;

#endregion



#region NinjaScript generated code. Neither change nor remove.

namespace NinjaTrader.NinjaScript.Indicators
{
	public partial class Indicator : NinjaTrader.Gui.NinjaScript.IndicatorRenderBase
	{
		
		private MillaBotIndicator[] cacheMillaBotIndicator;
		private AuSuperSmootherFilter[] cacheAuSuperSmootherFilter;

		
		public MillaBotIndicator MillaBotIndicator(NinjaTrader.NinjaScript.Indicators.IndicatorTradingMode selectedMode, bool useS4_RetestToDivMarkX, int zonePivotLoopback0, int retestMinScore, int contract, double stopLoss_To_Profit_Target_Ratio, int verticalOffsetRows, bool showHub, bool useS2_RetestMarkX, bool showAlignmentGauges, bool useSRDetector, int fontSize)
		{
			return MillaBotIndicator(Input, selectedMode, useS4_RetestToDivMarkX, zonePivotLoopback0, retestMinScore, contract, stopLoss_To_Profit_Target_Ratio, verticalOffsetRows, showHub, useS2_RetestMarkX, showAlignmentGauges, useSRDetector, fontSize);
		}

		public AuSuperSmootherFilter AuSuperSmootherFilter(int poles, int period)
		{
			return AuSuperSmootherFilter(Input, poles, period);
		}


		
		public MillaBotIndicator MillaBotIndicator(ISeries<double> input, NinjaTrader.NinjaScript.Indicators.IndicatorTradingMode selectedMode, bool useS4_RetestToDivMarkX, int zonePivotLoopback0, int retestMinScore, int contract, double stopLoss_To_Profit_Target_Ratio, int verticalOffsetRows, bool showHub, bool useS2_RetestMarkX, bool showAlignmentGauges, bool useSRDetector, int fontSize)
		{
			if (cacheMillaBotIndicator != null)
				for (int idx = 0; idx < cacheMillaBotIndicator.Length; idx++)
					if (cacheMillaBotIndicator[idx].SelectedMode == selectedMode && cacheMillaBotIndicator[idx].UseS4_RetestToDivMarkX == useS4_RetestToDivMarkX && cacheMillaBotIndicator[idx].ZonePivotLoopback0 == zonePivotLoopback0 && cacheMillaBotIndicator[idx].RetestMinScore == retestMinScore && cacheMillaBotIndicator[idx].Contract == contract && cacheMillaBotIndicator[idx].StopLoss_To_Profit_Target_Ratio == stopLoss_To_Profit_Target_Ratio && cacheMillaBotIndicator[idx].VerticalOffsetRows == verticalOffsetRows && cacheMillaBotIndicator[idx].ShowHub == showHub && cacheMillaBotIndicator[idx].UseS2_RetestMarkX == useS2_RetestMarkX && cacheMillaBotIndicator[idx].ShowAlignmentGauges == showAlignmentGauges && cacheMillaBotIndicator[idx].UseSRDetector == useSRDetector && cacheMillaBotIndicator[idx].FontSize == fontSize && cacheMillaBotIndicator[idx].EqualsInput(input))
						return cacheMillaBotIndicator[idx];
			return CacheIndicator<MillaBotIndicator>(new MillaBotIndicator(){ SelectedMode = selectedMode, UseS4_RetestToDivMarkX = useS4_RetestToDivMarkX, ZonePivotLoopback0 = zonePivotLoopback0, RetestMinScore = retestMinScore, Contract = contract, StopLoss_To_Profit_Target_Ratio = stopLoss_To_Profit_Target_Ratio, VerticalOffsetRows = verticalOffsetRows, ShowHub = showHub, UseS2_RetestMarkX = useS2_RetestMarkX, ShowAlignmentGauges = showAlignmentGauges, UseSRDetector = useSRDetector, FontSize = fontSize }, input, ref cacheMillaBotIndicator);
		}

		public AuSuperSmootherFilter AuSuperSmootherFilter(ISeries<double> input, int poles, int period)
		{
			if (cacheAuSuperSmootherFilter != null)
				for (int idx = 0; idx < cacheAuSuperSmootherFilter.Length; idx++)
					if (cacheAuSuperSmootherFilter[idx].Poles == poles && cacheAuSuperSmootherFilter[idx].Period == period && cacheAuSuperSmootherFilter[idx].EqualsInput(input))
						return cacheAuSuperSmootherFilter[idx];
			return CacheIndicator<AuSuperSmootherFilter>(new AuSuperSmootherFilter(){ Poles = poles, Period = period }, input, ref cacheAuSuperSmootherFilter);
		}

	}
}

namespace NinjaTrader.NinjaScript.MarketAnalyzerColumns
{
	public partial class MarketAnalyzerColumn : MarketAnalyzerColumnBase
	{
		
		public Indicators.MillaBotIndicator MillaBotIndicator(NinjaTrader.NinjaScript.Indicators.IndicatorTradingMode selectedMode, bool useS4_RetestToDivMarkX, int zonePivotLoopback0, int retestMinScore, int contract, double stopLoss_To_Profit_Target_Ratio, int verticalOffsetRows, bool showHub, bool useS2_RetestMarkX, bool showAlignmentGauges, bool useSRDetector, int fontSize)
		{
			return indicator.MillaBotIndicator(Input, selectedMode, useS4_RetestToDivMarkX, zonePivotLoopback0, retestMinScore, contract, stopLoss_To_Profit_Target_Ratio, verticalOffsetRows, showHub, useS2_RetestMarkX, showAlignmentGauges, useSRDetector, fontSize);
		}

		public Indicators.AuSuperSmootherFilter AuSuperSmootherFilter(int poles, int period)
		{
			return indicator.AuSuperSmootherFilter(Input, poles, period);
		}


		
		public Indicators.MillaBotIndicator MillaBotIndicator(ISeries<double> input , NinjaTrader.NinjaScript.Indicators.IndicatorTradingMode selectedMode, bool useS4_RetestToDivMarkX, int zonePivotLoopback0, int retestMinScore, int contract, double stopLoss_To_Profit_Target_Ratio, int verticalOffsetRows, bool showHub, bool useS2_RetestMarkX, bool showAlignmentGauges, bool useSRDetector, int fontSize)
		{
			return indicator.MillaBotIndicator(input, selectedMode, useS4_RetestToDivMarkX, zonePivotLoopback0, retestMinScore, contract, stopLoss_To_Profit_Target_Ratio, verticalOffsetRows, showHub, useS2_RetestMarkX, showAlignmentGauges, useSRDetector, fontSize);
		}

		public Indicators.AuSuperSmootherFilter AuSuperSmootherFilter(ISeries<double> input , int poles, int period)
		{
			return indicator.AuSuperSmootherFilter(input, poles, period);
		}
	
	}
}

namespace NinjaTrader.NinjaScript.Strategies
{
	public partial class Strategy : NinjaTrader.Gui.NinjaScript.StrategyRenderBase
	{
		
		public Indicators.MillaBotIndicator MillaBotIndicator(NinjaTrader.NinjaScript.Indicators.IndicatorTradingMode selectedMode, bool useS4_RetestToDivMarkX, int zonePivotLoopback0, int retestMinScore, int contract, double stopLoss_To_Profit_Target_Ratio, int verticalOffsetRows, bool showHub, bool useS2_RetestMarkX, bool showAlignmentGauges, bool useSRDetector, int fontSize)
		{
			return indicator.MillaBotIndicator(Input, selectedMode, useS4_RetestToDivMarkX, zonePivotLoopback0, retestMinScore, contract, stopLoss_To_Profit_Target_Ratio, verticalOffsetRows, showHub, useS2_RetestMarkX, showAlignmentGauges, useSRDetector, fontSize);
		}

		public Indicators.AuSuperSmootherFilter AuSuperSmootherFilter(int poles, int period)
		{
			return indicator.AuSuperSmootherFilter(Input, poles, period);
		}


		
		public Indicators.MillaBotIndicator MillaBotIndicator(ISeries<double> input , NinjaTrader.NinjaScript.Indicators.IndicatorTradingMode selectedMode, bool useS4_RetestToDivMarkX, int zonePivotLoopback0, int retestMinScore, int contract, double stopLoss_To_Profit_Target_Ratio, int verticalOffsetRows, bool showHub, bool useS2_RetestMarkX, bool showAlignmentGauges, bool useSRDetector, int fontSize)
		{
			return indicator.MillaBotIndicator(input, selectedMode, useS4_RetestToDivMarkX, zonePivotLoopback0, retestMinScore, contract, stopLoss_To_Profit_Target_Ratio, verticalOffsetRows, showHub, useS2_RetestMarkX, showAlignmentGauges, useSRDetector, fontSize);
		}

		public Indicators.AuSuperSmootherFilter AuSuperSmootherFilter(ISeries<double> input , int poles, int period)
		{
			return indicator.AuSuperSmootherFilter(input, poles, period);
		}

	}
}

#endregion
